<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" omit-xml-declaration ="yes" encoding="UTF-8"/> 
	<xsl:template match="/DICOMDIR">
		<HTML>
			<head>
				<TITLE>Study <xsl:value-of select="./PATIENT/STUDY[./STYID='@STYID']/STYID"/>
				</TITLE>
				<style type="text/css">
					body {background-color: #3C3C3C}
					a:link { color: #2C5666; }
					a:visited { color: #3296C8; }
				</style>
				<link rel="stylesheet" type="text/css" media="screen, handheld, print" href="IHE_HTML.css"/>
			</head>
			<body>
				<xsl:apply-templates select="./PATIENT/STUDY[./STYID='@STYID']"/>
			</body>
		</HTML>
	</xsl:template>
	
	<xsl:template match="STUDY[./STYID='@STYID']">
		<center>
			<table border="0" width="100%" id="TABLEPAZIENTE">
				<tr>
					<td>
						<xsl:element name="A">
						<xsl:attribute name="name">start</xsl:attribute>
						</xsl:element>
					</td>
					<td>
						<td colspan="1" class="PATIENTLABELTEXT">Identificativo:</td>
						<td colspan="1" nowrap="1" class="PATIENTFIELDTEXT"><xsl:value-of select="STYID"/></td>
						<td class="PATIENTLABELTEXT">Descrizione:</td>
						<td nowrap="1" class="PATIENTFIELDTEXT"><xsl:value-of select="STYDESCRIPTION"/></td>
						<td class="PATIENTLABELTEXT">Data:</td>
						<td class="PATIENTFIELDTEXT"><xsl:call-template name="STYDATE"/></td>
					</td>
				</tr>
				<table><tr><td>&#160;</td></tr></table><!--Serve solo a dividere le due tabelle principali-->
				<table border="0" width="100%" id="StudyBody">
					<tr>
						<td class="PATIENTLABELTEXT">
							<xsl:element name="A">
							<xsl:attribute name="href">../index.htm</xsl:attribute>
							<xsl:attribute name="style">cursor:hand</xsl:attribute>Torna all'indice esami
							</xsl:element>
						</td>
					</tr>
					<xsl:for-each select="./SERIES">
						<tr>
							<td>
								<xsl:variable name="SERMODALITY" select="SERMODALITY"/>
								<xsl:choose>
									<xsl:when test="$SERMODALITY = 'SR' and count(STRUCTURED_REPORT) > 0"/>		
									<xsl:when test="$SERMODALITY = 'PR'"/>
									<xsl:when test="$SERMODALITY = 'KO'"/>
									<xsl:when test="$SERMODALITY = 'DOC'"/>
									<xsl:when test="$SERMODALITY = 'PDF'"/>
									<xsl:otherwise>
										<xsl:choose>
											<xsl:when test="(position() mod 2) = 0">
												<xsl:attribute name="class">RowEven</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>  
												<xsl:attribute name="class">RowOdd</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:element name="A">
											<xsl:attribute name="href">#SERID-<xsl:value-of select="SERID"/></xsl:attribute>
											<xsl:attribute name="style">cursor:hand</xsl:attribute> Serie(ID: <xsl:value-of select="SERID"/>)
											<xsl:value-of select="SERMODALITY"/> - <xsl:value-of select="SERDESCRIPTION"/>
										</xsl:element>
									</xsl:otherwise>
								</xsl:choose>
							</td>
						</tr>
					</xsl:for-each>
				</table>

				<xsl:for-each select="./SERIES">
				  <xsl:apply-templates select="."/>
				</xsl:for-each>
				
			</table>
		</center>
	</xsl:template><!-- STUDY-->
	
	<xsl:template match="SERIES">
		<xsl:variable name="SERMODALITY" select="SERMODALITY"/>
		<xsl:choose>
			<xsl:when test=" ($SERMODALITY = 'SR' and count(STRUCTURED_REPORT) > 0) or($SERMODALITY = 'PR') or ($SERMODALITY = 'KO') or ($SERMODALITY = 'DOC') or ($SERMODALITY = 'PDF')"/>	
			<xsl:otherwise>
				<tr><td>&#160;</td></tr>
				<table border="0" width="100%" id="TABLEPAZIENTE">
					<tr>
						<xsl:element name="A">
							<xsl:attribute name="name">SERID-<xsl:value-of select="SERID"/></xsl:attribute>
						</xsl:element>
						<td valign="top" align="center" nowrap="1" class="PATIENTFIELDTEXT">
							Serie(ID: <xsl:value-of select="SERID"/>) <xsl:value-of select="SERMODALITY"/> - <xsl:value-of select="SERDESCRIPTION"/>
						</td>				
					</tr>
					<xsl:choose>
						<xsl:when test="($SERMODALITY = 'CR')">
							<xsl:for-each select="./IMAGE">
								<tr>
									<td align="left">					
										<xsl:element name="a">
											<xsl:attribute name="href">
												<xsl:value-of select="PATH"/>
											</xsl:attribute>		
											<xsl:element name="img">
												<xsl:attribute name="src"><xsl:value-of select="PATH"/></xsl:attribute>
												<xsl:attribute name="width">100%</xsl:attribute>
												<xsl:attribute name="border">0</xsl:attribute>											
												<xsl:attribute name="alt">Serie: <xsl:value-of select="../SERID"/> - <xsl:value-of select="../SERDESCRIPTION"/>
	Immagine: <xsl:value-of select="IMGID"/></xsl:attribute>
											</xsl:element>
										</xsl:element>
									</td>
								</tr>
							</xsl:for-each>	
						</xsl:when>
						<xsl:when test="($SERMODALITY = 'MG')">
							<xsl:for-each select="./IMAGE">
								<xsl:variable name="row-pos" select="position()"/>
								<xsl:if test="($row-pos mod 2) = 1">
									<tr>
										<td align="left">																
											<xsl:for-each select="../IMAGE">
												<xsl:variable name="innerrow-pos" select="position()"/>									
												<xsl:if test="($row-pos = $innerrow-pos) or ($row-pos+1 = $innerrow-pos)">																					
													<xsl:element name="a">
														<xsl:attribute name="href">
															<xsl:value-of select="PATH"/>
														</xsl:attribute>																						
														<xsl:element name="img">
															<xsl:attribute name="src"><xsl:value-of select="PATH"/></xsl:attribute>
															<xsl:attribute name="width">48%</xsl:attribute>	
															<xsl:attribute name="border">0</xsl:attribute>														
															<xsl:attribute name="alt">Serie: <xsl:value-of select="../SERID"/> - <xsl:value-of select="../SERDESCRIPTION"/> 
	Immagine: <xsl:value-of select="IMGID"/></xsl:attribute>
														</xsl:element>
													</xsl:element>												
												</xsl:if>									
											</xsl:for-each>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>									
						</xsl:when>
						<xsl:otherwise>
							<xsl:for-each select="./IMAGE">
								<xsl:variable name="row-pos" select="position()"/>
								<xsl:if test="($row-pos mod 3) = 1">
									<tr>
										<td align="left">																
											<xsl:for-each select="../IMAGE">
												<xsl:variable name="innerrow-pos" select="position()"/>									
												<xsl:if test="($row-pos = $innerrow-pos) or ($row-pos+1 = $innerrow-pos) or ($row-pos+2 = $innerrow-pos)">																					
													<xsl:element name="a">
														<xsl:attribute name="href">
															<xsl:value-of select="PATH"/>
														</xsl:attribute>																						
														<xsl:element name="img">
															<xsl:attribute name="src"><xsl:value-of select="PATH"/></xsl:attribute>
															<xsl:attribute name="width">32%</xsl:attribute>	
															<xsl:attribute name="border">0</xsl:attribute>														
															<xsl:attribute name="alt">Serie: <xsl:value-of select="../SERID"/> - <xsl:value-of select="../SERDESCRIPTION"/> 
	Immagine: <xsl:value-of select="IMGID"/></xsl:attribute>
														</xsl:element>
													</xsl:element>												
												</xsl:if>									
											</xsl:for-each>
										</td>
									</tr>
								</xsl:if>
							</xsl:for-each>									
						</xsl:otherwise>
					</xsl:choose>
					<td width="25%" class="PATIENTFIELDTEXT">
						<xsl:element name="A">
						<xsl:attribute name="href">#start</xsl:attribute>
						<xsl:attribute name="style">cursor:hand</xsl:attribute>Torna all'inizio</xsl:element>
					</td>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="STYDATE">
		<xsl:variable name="date" select="STYDATE"/>
		<xsl:value-of select="substring($date,7,2)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,1,4)"/>
	</xsl:template>
</xsl:stylesheet>
