<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2000/10/XMLSchema-instance">
	<xsl:output method="xml" indent="yes" omit-xml-declaration ="yes" encoding="UTF-8"/> 
	<xsl:key name="gr_node" match="*" use="name()"/>
	<xsl:template match="STRUCTUREDREPORT">
		<html>
			<head>
				<title>Report - b</title>
				<link rel="stylesheet" type="text/css" media="screen, handheld, print" href="/IHE_REPORT.css"/>
				<style>
				.INTESTAZIONETEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 16pt;
					font-weight: bold;
					padding: 1px;
					color: #000000;
				}
				.SUBINTESTAZIONETEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 12pt;
					font-weight: normal;
					font-style: oblique;
					padding: 4px;
					color: #000000;
				}
				.LUOGOTEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 14pt;
					font-weight: normal;
					padding: 4px;
					color: #000000;
				}
				.MEDICOTEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 14pt;
					font-weight: bold;
					padding: 4px;
					color: #000000;
				}
				.PIEDIPAGINATEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 10pt;
					font-weight: normal;
					font-style: oblique;
					padding-top: 4px;
					color: #000000;
				}
				.TABLECONTAINER
				{
					border: #cccccc 1px solid;
   					background-color: "#919191";
				}
				.TABLEDATA
				{	
					border: #cccccc 1px solid;						
   					background-color: #ffffff;
				}
				.PATIENTLABELTEXT
				{
					font-weight: bold;
					padding: 4px;
					color: #000000;
					background-color: #ffffff;
				}
				.SECONDPATIENTLABELTEXT
				{
					font-family: "Times New Roman", serif;
					font-weight: normal;
					<!--font-style: oblique;
					padding: 4px;-->
					color: #000000;
					background-color: "#919191";
				}
				.PATIENTFIELDTEXT
				{
					font-family: "Times New Roman", serif;
					font-weight: normal;
					padding: 4px;
					color:  #000000;
					background-color:#ffffff;
				}
				.DATACONTAINER
				{				
					border-left: #cccccc 1px solid;
					padding-left: 6px;
					border-bottom: #aaaaaa 1px solid;
					padding-bottom: 6px;
					
					font-size: 14pt;
					font-weight: bold;
					font-variant: normal;
					color:  #000000;
					background-color: "#919191";
				}
				.IMAGE
				{
					font-size: 14pt;
					font-weight: bold;
					color:  #000000;
					background-color: "#919191";
				}
				.DATALABEL
				{
					font-size: 14pt;
					font-weight: normal;
					text-align: left;
					color:  #000000;
					background-color: "#919191";
				}
				.DATAVALUE
				{						
					font-size: 14pt;
					font-weight: bold;
					color:  #000000;
					background-color: "#919191";
				}
				.RowEvenLbl
				{
					font-size: 14pt;
					color:  #000000;
					background-color: #ffffff;
				}
				.RowOddLbl
				{
					font-size: 14pt;
					color:  #000000;
					background-color: #ffffff;						
				}
				.RowEvenValue
				{
					font-size: 14pt;
					font-weight: bold;
					color:  #000000;
					background-color: #ffffff;
				}
				.RowOddValue
				{
					font-size: 14pt;
					font-weight: bold;
					color: #000000;
					background-color: #ffffff;
				}
				dl
				{
					margin-top: 0em; 
					margin-bottom: 0,5em;
					width="100%";
				}	
				dd
				{
					margin-top: 0em; 
					margin-bottom: 0,5em;
					width="100%";
				}
				body
				{
					scrollbar-base-color: #353739;	
					scrollbar-track-color: #353739;
					scrollbar-face-color: #919191;
					scrollbar-arrow-color: #353739;		
					scrollbar-shadow-color: #353739;
					scrollbar-dark-shadow-color: #353739
					scrollbar-3dlight-color: #353739;
				}		
                </style>
			    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			</head>
			<body  style="padding-left: 20; padding-right: 20; width: 100%;" bgcolor="#919191">
				<!--HEADER-->
				<table height="100%" width="100%" cellpadding="0" cellspacing="0">
					<tr>
						<td>
							<table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" class="INTESTAZIONETEXT">
								<!--loghi-->
								<td valign="top" align="center">
									<img height="50" src="IHE_exprivia.gif"/>
								</td>
								<!--intestazione-->
								<tr>
									<td nowrap="0" align="center">Connectathon 2016</td>
								</tr>
								<tr>
									<td align="center" style="border-bottom: black 1px solid; font-size: 1pt" height="1px" valign="top" nowrap="0">
										<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<!--CORPO REFERTO-->
					<tr>
						<td>
							<table border="0" width="100%">
								<xsl:apply-templates select="*"/>
							</table>
						</td>
					</tr>			
					<!--FOOTER-->		
					<!--ultima riga del documento, eventuali note-->		
					<tr>
						<td height="100%">
							<table> <!--height="100%" border="0"-->
							    <tr> <td colspan="4">&#160;</td>	</tr>
								<tr> <td colspan="4">&#160;</td>	</tr>
								<tr>
									<td valign="bottom" align="left" nowrap="0"  class="PIEDIPAGINATEXT">
										<xsl:text>Questa pagina è stata generata da un documento Structured Report DICOM da</xsl:text> 
										<a href="http://www.exprivia.it/it" target="_blank"> MedStation </a> 
										<xsl:text>5.2</xsl:text>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="SRDATA">		
		<tr>
			<td>
				<table align="left" border="0" width="100%" cellspacing="0" cellpadding="0">
				<tr class="SECONDPATIENTLABELTEXT">
					<td nowrap="0"><b>Paziente: </b></td>
					<td>	
						<xsl:variable name="patName" select="PATIENTSNAME"/>
						<xsl:variable name="patNameNew" select="translate($patName,'^',' ')"/>
						<xsl:value-of select="translate($patNameNew,'*',' ')"/>
						 (ID: <xsl:value-of select="PATIENTID"/>)
					</td>
				</tr>
				<tr class="SECONDPATIENTLABELTEXT">
					<td nowrap="0"><b>Produttore: </b></td>
					<td>	
						<xsl:value-of select="MANUFACTURER"/> (<xsl:value-of select="MANUFACTURERSMODELNAME"/>, #<xsl:value-of select="DEVICESERIALNUMBER"/>)
					</td>
				</tr>
				<tr class="SECONDPATIENTLABELTEXT">	
					<td nowrap="0"><b>Completezza: </b></td>
					<td nowrap="0"> 
						<xsl:value-of select="COMPLETIONFLAG"/>
					</td>
				</tr>	
				<tr class="SECONDPATIENTLABELTEXT">
					<td nowrap="0"><b>Verifica: </b></td>
					<td nowrap="0">
						<xsl:value-of select="VERIFICATIONFLAG"/>
					</td>								
				</tr>
				<tr class="SECONDPATIENTLABELTEXT" >	
					<td nowrap="0"><b>Data/Ora del contenuto: </b></td>
					<td nowrap="0"> 
						<xsl:variable name="date" select="CONTENTDATE"/>
						<xsl:variable name="time" select="CONTENTTIME"/>
						<xsl:value-of select="substring($date,1,4)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,7,2)"/>&#160; 	
						<xsl:value-of select="substring($time,1,2)"/>:<xsl:value-of select="substring($time,3,2)"/>:<xsl:value-of select="substring($time,5,2)"/>
					</td>
				</tr>
				<tr>
					<td colspan="2" align="center" style="border-bottom: black 1px solid; font-size: 1pt" height="1px" valign="top" nowrap="0">
						<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
					</td>	
				</tr>
				<tr>
					<td colspan="4">&#160;</td>
				</tr>
				<!--
					<td nowrap="0">Data di nascita: 
						<xsl:variable name="birth" select="PATIENTSBIRTHDATE"/>
						<xsl:value-of select="substring($birth,7,2)"/>-<xsl:value-of select="substring($birth,5,2)"/>-<xsl:value-of select="substring($birth,1,4)"/>									
					</td>
				-->
				</table>						
			</td>
		</tr>			
	</xsl:template>

	<!-- ********************************************** -->
	<xsl:template match="CONTAINER">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
			<tr> <td colspan="4">&#160;</td> </tr>
			<tr> <td colspan="4">&#160;</td> </tr>
			<tr>						
				<td colspan="2" valign="middle" align="left" nowrap="0" > <!--style="font-weight: bold; font-size: 14pt; font-variant: normal;"-->
					<xsl:if test="generate-id() = generate-id(key('gr_node',name())[1])">
						<h1><xsl:value-of select="@CODEMEANING"/></h1>		
					</xsl:if>			
					<xsl:if test="generate-id() != generate-id(key('gr_node',name())[1])">
						<h2><xsl:value-of select="@CODEMEANING"/></h2>				
					</xsl:if>	
				</td>
				<!--xsl:apply-templates select="*"/-->					
			</tr>
		</table>
		<xsl:apply-templates select="*"/>		
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="TEXT">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
			<xsl:choose>
				<xsl:when test="@RELATIONSHIP='HAS OBS CONTEXT' or @RELATIONSHIP='HAS CONCEPT MOD' or @RELATIONSHIP='HAS PROPERTIES'">
					<tr>
						<td colspan="2">
							<xsl:call-template name="relationship"/> <xsl:value-of select="@CODEMEANING"/> = "<xsl:value-of select="DATAVALUE" disable-output-escaping="yes"/>"
						</td>
					</tr>	
				</xsl:when>
				<xsl:otherwise>
					<tr><td colspan="4">&#160;</td></tr>	
					<tr>
						<td>
							<b><xsl:value-of select="@CODEMEANING"/>:</b>
						</td>
					</tr>	
					<tr>	
						<td>
							<xsl:value-of select="DATAVALUE" disable-output-escaping="yes"/>
						</td>	
					</tr>
				</xsl:otherwise>
			</xsl:choose>		
		</table>
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="SCOORD">
		<!--<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr>
								<td valign="middle" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>
								</td>
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<xsl:value-of select="DATAVALUE/text()"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>-->
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="*">
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="NUM">
	    <table border="0" width="100%" cellspacing="0" cellpadding="0">
			<tr> <td colspan="4">&#160;</td> </tr>
			<tr>
				<td>
					<b>	<xsl:value-of select="@CODEMEANING"/></b>
				</td>
			</tr>	
			<tr>
				<td>
					<xsl:value-of select="DATAVALUE/text()"/>
					<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
					<xsl:value-of select="@UMCODEMEANING"/>
				</td>
			</tr>	
		</table>	
		<!--<xsl:apply-templates select="*"/>-->
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="CODE">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
			<xsl:choose>
				<xsl:when test="@RELATIONSHIP='HAS OBS CONTEXT' or @RELATIONSHIP='HAS CONCEPT MOD'">
					<tr>
						<td colspan="2">
							<xsl:call-template name="relationship"/> <xsl:value-of select="@CODEMEANING"/> = <xsl:value-of select="@CDCODEMEANING"/> (<xsl:value-of select="@CDCODEVALUE"/>, <xsl:value-of select="@CDCODESCHEME"/>)
						</td>
					</tr>
				</xsl:when>
				<xsl:otherwise>
					<tr>
						<td colspan="4">&#160;</td>
					</tr>
					<tr>
						<td><b>	<xsl:value-of select="@CODEMEANING"/>: </b>	</td>
					</tr>	
					<tr>
						<td>
							<xsl:value-of select="@CDCODEMEANING"/> (<xsl:value-of select="@CDCODEVALUE"/>, <xsl:value-of select="@CDCODESCHEME"/>)
						</td>
					</tr>	
				</xsl:otherwise>
			</xsl:choose>
			<xsl:if test="count(child::*) > 0">
				<!--xsl:apply-templates select="*"/-->
				<tr>
					<td colspan="2">
						<dl>
							<dd>
								<!--table border="0" width="100%"-->
									<xsl:apply-templates select="*"/>
								<!--/table-->
							</dd>
						</dl>
					</td>
				</tr>
			</xsl:if>
		</table>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="UIDREF">
	    <table border="0" width="100%" cellspacing="0" cellpadding="0">
			<xsl:choose>
				<xsl:when test="@RELATIONSHIP='HAS OBS CONTEXT' or @RELATIONSHIP='HAS CONCEPT MOD' or @RELATIONSHIP='HAS PROPERTIES'">
					<tr>
						<td colspan="2">
							<xsl:call-template name="relationship"/> <xsl:value-of select="@CODEMEANING"/> = <xsl:value-of select="DATAVALUE" disable-output-escaping="yes"/>
						</td>
					</tr>	
				</xsl:when>
				<xsl:otherwise>
					<tr><td colspan="4">&#160;</td></tr>	
					<tr>
						<td>
							<b><xsl:value-of select="@CODEMEANING"/>:</b>
						</td>
					</tr>	
					<tr>	
						<td>
							<xsl:value-of select="DATAVALUE" disable-output-escaping="yes"/>
						</td>	
					</tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="COMPOSITE">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="IMAGE">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
			<tr>
				<td colspan="2">
					<dl>
						<dd>
							<table border="0" width="100%" cellpadding="0" cellspacing="0">
								<tr>
									<td valign="top" align="left" nowrap="0">
										<xsl:value-of select="@CODEMEANING"/>: 
									</td>
									<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
										<xsl:choose>
											<xsl:when test="normalize-space(string(@SOPINSTANCEWADOURL)) != '' " >									
												<xsl:element name="img">
													<xsl:attribute name="src">
														<xsl:value-of select="@SOPINSTANCEWADOURL"/>&amp;rows=256&amp;columns=256&amp;contentType=image/jpeg
													</xsl:attribute>
												</xsl:element>
											</xsl:when>
											<xsl:otherwise>
												<xsl:element name="a">
													<xsl:attribute name="href">localhost:/<xsl:value-of select="@SOPINSTANCEUID"/></xsl:attribute>
													<xsl:value-of select="@SOPINSTANCEUID"/>
												</xsl:element>
											</xsl:otherwise>
										</xsl:choose>		
									</td>
								</tr>
								<xsl:apply-templates select="*"/>
							</table>
						</dd>
					</dl>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="DATE">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
			<tr>
				<td nowrap="0">
					<b><xsl:value-of select="@CODEMEANING"/>: </b>
				</td>
				<xsl:variable name="date" select="DATAVALUE/text()"/>
				<td nowrap="0">
					<xsl:value-of select="substring($date,1,4)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,7,2)"/>
				</td>
			</tr>
		</table>	
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="TIME">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
		<tr>
			<td>
				<b><xsl:value-of select="@CODEMEANING"/>: </b>
			</td>
			<xsl:variable name="time" select="DATAVALUE/text()"/>
			<td>
				<xsl:value-of select="substring($time,1,2)"/>:<xsl:value-of select="substring($time,3,2)"/>:<xsl:value-of select="substring($time,5,2)"/>
			</td>
		</tr>
		</table>
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="PNAME">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
			<tr><td colspan="4">&#160;</td></tr>	
			<tr>
				<xsl:variable name="name" select="DATAVALUE/text()"/>
				<xsl:variable name="patNameNew" select="translate($name,'^',' ')"/>
				<td nowrap="0">
					<b><xsl:value-of select="@CODEMEANING"/>: </b> 						
					<xsl:value-of select="translate($patNameNew,'*',' ')"/>
				</td>									
			</tr>
			</table>
			<xsl:apply-templates select="*"/>		
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="DATETIME">
		<table border="0" width="100%" cellspacing="0" cellpadding="0">
			<tr><td colspan="4">&#160;</td></tr>	
			<tr>
				<td>
					<b><xsl:value-of select="@CODEMEANING"/>:</b>
				</td>
			</tr>	
			<tr>
				<xsl:variable name="datetime" select="DATAVALUE/text()"/>
				<td>
					<xsl:value-of select="substring($datetime,1,4)"/>-<xsl:value-of select="substring($datetime,5,2)"/>-<xsl:value-of select="substring($datetime,7,2)"/>
					<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
					<xsl:value-of select="substring($datetime,9,2)"/>:<xsl:value-of select="substring($datetime,11,2)"/>:<xsl:value-of select="substring($datetime,13,2)"/>
				</td>
			</tr>	
		</table>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template name="STYDATE">
		<xsl:variable name="date" select="STUDYDATE"/>
		<xsl:value-of select="substring($date,7,2)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,1,4)"/>
	</xsl:template>	
	<!-- ********************************************** -->
	<xsl:template name="relationship">
		<xsl:variable name="rel" select="@RELATIONSHIP"/>
		<xsl:choose>
			<xsl:when test="$rel='HAS OBS CONTEXT'">
				<xsl:text>Observation Contex: </xsl:text> 
			</xsl:when>
			<xsl:when test="$rel='HAS CONCEPT MOD'">
				<xsl:text>Concept Modifier: </xsl:text>
			</xsl:when>
			<xsl:when test="$rel='HAS PROPERTIES'">
				<xsl:text>Properties: </xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
