﻿<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2000/10/XMLSchema-instance">
	<xsl:output method="xml" indent="yes" omit-xml-declaration ="yes" encoding="UTF-8"/> 
	<xsl:template match="STRUCTUREDREPORT">
		<html>
			<head>
				<title>Report - b</title>
				<link rel="stylesheet" type="text/css" media="screen, handheld, print" href="/IHE_REPORT.css"/>
				<style>
				.INTESTAZIONETEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 22pt;
					font-weight: bold;
					padding: 4px;
					color: #000000;
				}
				.SUBINTESTAZIONETEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 12pt;
					font-weight: normal;
					font-style: oblique;
					padding: 4px;
					color: #000000;
				}
				.LUOGOTEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 14pt;
					font-weight: normal;
					padding: 4px;
					color: #000000;
				}
				.MEDICOTEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 14pt;
					font-weight: bold;
					padding: 4px;
					color: #000000;
				}
				.PIEDIPAGINATEXT
				{
					font-family: "Times New Roman", serif;
					font-size: 10pt;
					font-weight: normal;
					font-style: oblique;
					padding-top: 4px;
					color: #000000;
				}
				.TABLECONTAINER
				{
					border: #cccccc 1px solid;
   					background-color: "#919191";
				}
				.TABLEDATA
				{	
					border: #cccccc 1px solid;						
   					background-color: #ffffff;
				}
				.PATIENTLABELTEXT
				{
					font-weight: bold;
					padding: 4px;
					color: #000000;
					background-color: #ffffff;
				}
				.SECONDPATIENTLABELTEXT
				{
					font-family: "Times New Roman", serif;
					font-weight: normal;
					font-style: oblique;
					padding: 4px;
					color: #000000;
					background-color: "#919191";
				}
				.PATIENTFIELDTEXT
				{
					font-family: "Times New Roman", serif;
					font-weight: normal;
					padding: 4px;
					color:  #000000;
					background-color:#ffffff;
				}
				.DATACONTAINER
				{				
					border-left: #cccccc 1px solid;
					padding-left: 6px;
					border-bottom: #aaaaaa 1px solid;
					padding-bottom: 6px;
					
					font-size: 14pt;
					font-weight: bold;
					font-variant: normal;
					color:  #000000;
					background-color: "#919191";
				}
				.IMAGE
				{
					font-size: 14pt;
					font-weight: bold;
					color:  #000000;
					background-color: "#919191";
				}
				.DATALABEL
				{
					font-size: 14pt;
					font-weight: normal;
					text-align: left;
					color:  #000000;
					background-color: "#919191";
				}
				.DATAVALUE
				{						
					font-size: 14pt;
					font-weight: bold;
					color:  #000000;
					background-color: "#919191";
				}
				.RowEvenLbl
				{
					font-size: 14pt;
					color:  #000000;
					background-color: #ffffff;
				}
				.RowOddLbl
				{
					font-size: 14pt;
					color:  #000000;
					background-color: #ffffff;						
				}
				.RowEvenValue
				{
					font-size: 14pt;
					font-weight: bold;
					color:  #000000;
					background-color: #ffffff;
				}
				.RowOddValue
				{
					font-size: 14pt;
					font-weight: bold;
					color: #000000;
					background-color: #ffffff;
				}
				dl
				{
					margin-top: 0em; 
					margin-bottom: 0,5em;
					width="100%";
				}	
				dd
				{
					margin-top: 0em; 
					margin-bottom: 0,5em;
					width="100%";
				}
				body
				{
					scrollbar-base-color: #353739;	
					scrollbar-track-color: #353739;
					scrollbar-face-color: #919191;
					scrollbar-arrow-color: #353739;		
					scrollbar-shadow-color: #353739;
					scrollbar-dark-shadow-color: #353739
					scrollbar-3dlight-color: #353739;
				}		
        </style>
				<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
			</head>
			<body  style="padding-left: 20; padding-right: 20; width: 100%;" bgcolor="#919191">
				<!--HEADER-->
				<table height="100%" width="100%" cellpadding="0" cellspacing="0">
					<tr>
						<td>
							<table border="0" width="100%" cellpadding="0" cellspacing="0" align="center" class="INTESTAZIONETEXT">
								<!--loghi-->
								<td valign="top" align="center">
									<img height="100" src="IHE_exprivia.gif"/>
								</td>
								<!--<td valign="top" align="right">
									<img height="120" src="IHE_LOGO.gif"/>
								</td>-->
								<!--intestazione-->
								<tr>
									<td nowrap="0" align="center">Servizi di Radiologia Ecografia Mammografia</td>
								</tr>
								<tr>
									<td nowrap="0" align="center">Risonanza Magnetica Osteo-Articolare</td>
								</tr>
								<tr>
									<td nowrap="0" align="center">ULSS abc</td>
								</tr>
								<tr>
									<td align="center" nowrap="0" class="SUBINTESTAZIONETEXT">Via xyz, n. - C.A.P. Città (Provincia) tel. 1234567890</td>
								</tr>
								<tr>
									<td align="center" style="border-bottom: black 1px solid; font-size: 1pt" height="1px" valign="top" nowrap="0">
										<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<!--CORPO REFERTO-->
					<tr>
						<td>
							<table border="0" width="100%">
								<xsl:apply-templates select="*"/>
							</table>
						</td>
					</tr>			
					<!--FOOTER-->
					<tr>
						<td>
							<table width="100%" cellspacing="0" cellpadding="0" border="0">
								<tr>						
									<td>							
										<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
									</td>						
								</tr>					
								<!-- luogo e data-->		
								<tr>					
									<td align="left" nowrap="0" class="LUOGOTEXT">							
										<xsl:text>Paese,  </xsl:text>
										<xsl:variable name="contdate" select="/STRUCTUREDREPORT/SRDATA/CONTENTDATE"/>
										<xsl:value-of select="substring($contdate,7,2)"/>-<xsl:value-of select="substring($contdate,5,2)"/>-<xsl:value-of select="substring($contdate,1,4)"/>
									</td>						
								</tr>
								<!-- Firma del medico refertante-->
								<tr>
									<td align="right" width="70%" nowrap="0" class="MEDICOTEXT">
										<xsl:text>Dr. </xsl:text>
										<xsl:choose>
											<xsl:when test="//CONTAINER/PNAME/@RELATIONSHIP='HAS OBS CONTEXT'">
												<xsl:for-each select="//CONTAINER/PNAME">
													<xsl:if test="@RELATIONSHIP='HAS OBS CONTEXT'">
													<xsl:if test="@CODEVALUE = '121008'">
													<xsl:if test="@CODINGSCHEMEDESIGNATOR='DCM'">
														<xsl:variable name="authorName" select="DATAVALUE/text()"/>
														<xsl:variable name="patNameNew" select="translate($authorName,'^',' ')"/>
														<xsl:value-of select="translate($patNameNew,'*',' ')"/>
													</xsl:if>	
													</xsl:if>
													</xsl:if>
												</xsl:for-each>
											</xsl:when>
											<xsl:otherwise>
												<xsl:variable name="authorName" select="/STRUCTUREDREPORT/SRDATA/AUTHOROBSERVERSEQUENCE/PERSONNAME"/>
												<xsl:variable name="patNameNew" select="translate($authorName,'^',' ')"/>
												<xsl:value-of select="translate($patNameNew,'*',' ')"/>
											</xsl:otherwise>
										</xsl:choose>
										<!--<xsl:for-each select="//CONTAINER/PNAME">
											<xsl:if test="@RELATIONSHIP='HAS OBS CONTEXT'">
											<xsl:if test="@CODEVALUE = '121008'">
											<xsl:if test="@CODINGSCHEMEDESIGNATOR='DCM'">
												<xsl:variable name="authorName" select="DATAVALUE/text()"/>
												<xsl:variable name="patNameNew" select="translate($authorName,'^',' ')"/>
												<xsl:value-of select="translate($patNameNew,'*',' ')"/>
											</xsl:if>	
											</xsl:if>
											</xsl:if>
										</xsl:for-each>-->
										<!--<xsl:variable name="authorName" select="/STRUCTUREDREPORT/SRDATA/AUTHOROBSERVERSEQUENCE/PERSONNAME"/>
										<xsl:variable name="patNameNew" select="translate($authorName,'^',' ')"/>
										<xsl:value-of select="translate($patNameNew,'*',' ')"/>-->
									</td>
								</tr>									
							</table>
						</td>	
					</tr>				
					<!--ultima riga del documento, eventuali note-->		
					<tr>
						<td height="100%">
							<table height="100%" border="0" align="center">
								<tr>
									<td valign="bottom" align="center" nowrap="0"  class="PIEDIPAGINATEXT">
										<xsl:text>N.B.: Conservare il presente referto e riportarlo in caso di controlli</xsl:text>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<!-- ********************************************** -->
	<!--<xsl:template match="SRDATA">
		<dl>
			<dd>
				<tr>
					<td>
						<table class="TABLECONTAINER" align="center" border="0" width="75%">
							<tr>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">Nome Paziente:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:value-of select="PATIENTSNAME"/>
								</td>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">ID Paziente:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:value-of select="PATIENTID"/>
								</td>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">Sesso:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:value-of select="PATIENTSSEX"/>
								</td>
							</tr>
							<tr>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">Data di nascita:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:variable name="birth" select="PATIENTSBIRTHDATE"/>
									<xsl:value-of select="substring($birth,7,2)"/>-<xsl:value-of select="substring($birth,5,2)"/>-<xsl:value-of select="substring($birth,1,4)"/>									
								</td>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">Data esame:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:variable name="date" select="STUDYDATE"/>
									<xsl:value-of select="substring($date,7,2)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,1,4)"/>
								</td>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">Ora esame:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:variable name="time" select="STUDYTIME"/>
									<xsl:value-of select="substring($time,1,2)"/>:<xsl:value-of select="substring($time,3,2)"/>:<xsl:value-of select="substring($time,5,2)"/>
								</td>
							</tr>
							<tr>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">Stato referto:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:value-of select="COMPLETIONFLAG"/>
								</td>
								<td colspan="1" nowrap="0" class="PATIENTLABELTEXT">Verifica:</td>
								<td colspan="1" width="33%" class="PATIENTFIELDTEXT">
									<xsl:value-of select="VERIFICATIONFLAG"/>
								</td>
								<td/>
							</tr>
						</table>
					</td>
				</tr>
				<tr>
					<td colspan="4">&#160;</td>
				</tr>
			</dd>
		</dl>
	</xsl:template>-->
	<!-- un'altra versione-->
	<xsl:template match="SRDATA">
		<dl>
			<dd>
				<tr>
					<td>
						<table class="TABLECONTAINER" align="center" border="0" width="100%" cellspacing="0" cellpadding="0">
							<tr  class="SECONDPATIENTLABELTEXT">
								<td style="font-weight: bold;" nowrap="0">PAZIENTE </td>
								<td style="font-weight: bold;" nowrap="0">ESAME </td>
							</tr>	
							<tr class="SECONDPATIENTLABELTEXT">
								<td nowrap="0">Nome: 
									<xsl:variable name="patName" select="PATIENTSNAME"/>
									<xsl:variable name="patNameNew" select="translate($patName,'^',' ')"/>
									<xsl:value-of select="translate($patNameNew,'*',' ')"/>
								</td>
								<td nowrap="0">Data esame: 
									<xsl:variable name="date" select="STUDYDATE"/>
									<xsl:value-of select="substring($date,7,2)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,1,4)"/>
								</td>
							</tr>
							<tr class="SECONDPATIENTLABELTEXT" >	
								<td nowrap="0">ID: 
									<xsl:value-of select="PATIENTID"/>
								</td>
								<td>Ora esame: 
									<xsl:variable name="time" select="STUDYTIME"/>
									<xsl:value-of select="substring($time,1,2)"/>:<xsl:value-of select="substring($time,3,2)"/>:<xsl:value-of select="substring($time,5,2)"/>
								</td>
							</tr>
							<tr class="SECONDPATIENTLABELTEXT">	
								<td nowrap="0">Sesso: 
									<xsl:value-of select="PATIENTSSEX"/>
								</td>
								<td nowrap="0">Stato referto: 
									<xsl:value-of select="COMPLETIONFLAG"/>
								</td>
							</tr>	
							<tr class="SECONDPATIENTLABELTEXT">
								<td nowrap="0">Data di nascita: 
									<xsl:variable name="birth" select="PATIENTSBIRTHDATE"/>
									<xsl:value-of select="substring($birth,7,2)"/>-<xsl:value-of select="substring($birth,5,2)"/>-<xsl:value-of select="substring($birth,1,4)"/>									
								</td>
								<td nowrap="0">Verifica: 
									<xsl:value-of select="VERIFICATIONFLAG"/>
								</td>								
							</tr>
						</table>
						<tr>
							<td colspan="4">&#160;</td>
						</tr>						
					</td>
				</tr>
			</dd>
		</dl>
	</xsl:template>

	<!-- ********************************************** -->
	<xsl:template match="CONTAINER">
		<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr class="TABLECONTAINER">
								<td colspan="2" valign="middle" align="left" nowrap="0" class="DATACONTAINER">
									<xsl:value-of select="@CODEMEANING"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="TEXT">
		<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr>
								<td valign="top" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>: 
								</td>
									<td width="100%" valign="middle" align="left" class="DATAVALUE">
									<!--<xsl:value-of select="DATAVALUE/text()"/>-->
									<xsl:value-of select="DATAVALUE" disable-output-escaping="yes"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="SCOORD">
		<!--<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr>
								<td valign="middle" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>
								</td>
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<xsl:value-of select="DATAVALUE/text()"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>-->
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="*">
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="NUM">
		<tr>
			<td colspan="2" >
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr>
								<td valign="middle" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>:
								</td>
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<xsl:value-of select="DATAVALUE/text()"/>
									<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
									<xsl:value-of select="@UMCODEMEANING"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
			</tr>
			<!--<td colspan="1" valign="middle" align="left" nowrap="0" class="DATALABEL">
				<xsl:value-of select="@CODEMEANING"/>: 
			</td>
			<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
				<xsl:value-of select="DATAVALUE/text()"/>
				<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
				<xsl:value-of select="@UMCODEMEANING"/>
			</td>
		</tr>
		<xsl:apply-templates select="*"/>-->
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="CODE">
	<tr>
		<td colspan="2" >
			<dl>
				<dd>
					<table border="0" width="100%" cellpadding="3">
						<tr>
							<td valign="middle" align="left" nowrap="0" class="DATALABEL">
								<xsl:value-of select="@CODEMEANING"/>:
							</td>
							<td width="100%" valign="middle" align="left"  class="DATAVALUE">
								<xsl:value-of select="@CDCODEMEANING"/>
							</td>
						</tr>
						<xsl:apply-templates select="*"/>
					</table>
				</dd>
			</dl>
		</td>
	</tr>	
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="UIDREF">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="COMPOSITE">
		<xsl:apply-templates select="*"/>
	</xsl:template>
	<!-- ********************************************** -->
  <xsl:template match="IMAGE">
		<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%" cellpadding="0" cellspacing="0">
							<tr>
								<td valign="top" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>: 
								</td>
								<!-- <td valign="middle" align="left" nowrap="0" class="IMAGE">  
									<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
								</td> -->
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<xsl:choose>
										<xsl:when test="normalize-space(string(@SOPINSTANCEWADOURL)) != '' " >									
											<xsl:element name="img">
												<xsl:attribute name="src">
													<xsl:value-of select="@SOPINSTANCEWADOURL"/>&amp;rows=256&amp;columns=256&amp;contentType=image/jpeg
												</xsl:attribute>
											</xsl:element>
										</xsl:when>
										<xsl:otherwise>
											<xsl:element name="a">
												<xsl:attribute name="href">localhost:/<xsl:value-of select="@SOPINSTANCEUID"/></xsl:attribute>
												<xsl:value-of select="@SOPINSTANCEUID"/>
											</xsl:element>
										</xsl:otherwise>
									</xsl:choose>		
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="DATE">
		<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr>
								<td valign="middle" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>: 
								</td>
								<xsl:variable name="date" select="DATAVALUE/text()"/>
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<xsl:value-of select="substring($date,1,4)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,7,2)"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="TIME">
		<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr>
								<td valign="middle" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>:
								</td>
								<xsl:variable name="time" select="DATAVALUE/text()"/>
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<xsl:value-of select="substring($time,1,2)"/>:<xsl:value-of select="substring($time,3,2)"/>:<xsl:value-of select="substring($time,5,2)"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="PNAME">
		<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%" cellspacing="0" cellpadding="0">
							<tr>
								<td valign="middle" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>: 
								</td>
								<xsl:variable name="name" select="DATAVALUE/text()"/>
								<xsl:variable name="patNameNew" select="translate($name,'^',' ')"/>
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<!--<xsl:value-of select="DATAVALUE/text()"/>-->									
									<xsl:value-of select="translate($patNameNew,'*',' ')"/>
								</td>									
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>		
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template match="DATETIME">
		<tr>
			<td colspan="2">
				<dl>
					<dd>
						<table border="0" width="100%">
							<tr>
								<td valign="middle" align="left" nowrap="0" class="DATALABEL">
									<xsl:value-of select="@CODEMEANING"/>:
								</td>
								<xsl:variable name="datetime" select="DATAVALUE/text()"/>
								<td width="100%" valign="middle" align="left" nowrap="0" class="DATAVALUE">
									<xsl:value-of select="substring($datetime,1,4)"/>-<xsl:value-of select="substring($datetime,5,2)"/>-<xsl:value-of select="substring($datetime,7,2)"/>
									<xsl:text disable-output-escaping="yes"><![CDATA[ &nbsp;]]></xsl:text>
									<xsl:value-of select="substring($datetime,9,2)"/>:<xsl:value-of select="substring($datetime,11,2)"/>:<xsl:value-of select="substring($datetime,13,2)"/>
								</td>
							</tr>
							<xsl:apply-templates select="*"/>
						</table>
					</dd>
				</dl>
			</td>
		</tr>
	</xsl:template>
	<!-- ********************************************** -->
	<xsl:template name="STYDATE">
		<xsl:variable name="date" select="STUDYDATE"/>
		<xsl:value-of select="substring($date,7,2)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,1,4)"/>
	</xsl:template>	
	
</xsl:stylesheet>
