<?xml version="1.0" encoding="UTF-8"?>
	<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" omit-xml-declaration ="yes" encoding="UTF-8"/> 
	<xsl:template match="/DICOMDIR">
		<HTML>
			<head>
				<title>DICOMDIR INDEX</title>
				<style type="text/css">
					body {background-color: #3C3C3C}
					a:link { color: #2C5666; }
					a:visited { color: #3296C8; }
				</style>
				<link rel="stylesheet" type="text/css" media="screen, handheld, print" href="IHE_PDI/IHE_HTML.css"/>
			</head>
			<body>
				<table border="0" cellpadding="4" width="100%">
				<tr>
					<td align="center">
						<table width="100%" border="0">							
              <tr>																																	
                <td align="center">
                  <img border="0" height="80" src="IHE_PDI/IHE_logo.png" align="left"/>
                </td>
                <xsl:variable name="DISK_ID" select="DISKID"/>                
                <xsl:if test="$DISK_ID != ''">
                  <td width="10%" align="center" class='DISKIDTEXT'>                   
                    Disco <xsl:value-of select="DISKID"/>
                  </td>
                </xsl:if>
              </tr>								                    
						</table>
						</td>
					</tr>
					<tr>
						<td style="padding-left: 5%">
							<xsl:apply-templates select="PATIENT"/>
						</td>
					</tr>
					<tr align="center">
						<td colspan="3">
							<a href="http://www.exprivia.it">
								<img border="0" height="80" src="IHE_PDI/IHE_exprivia.png"/>
							</a>
						</td>
					</tr> 
			    </table>
			</body>
		</HTML>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template match="*">
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template name="PATBIRTHDATE">
		<xsl:variable name="date" select="PATBIRTHDATE"/>
		<xsl:value-of select="substring($date,7,2)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,1,4)"/>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template name="STYDATE">
		<xsl:variable name="date" select="STYDATE"/>
		<xsl:value-of select="substring($date,7,2)"/>-<xsl:value-of select="substring($date,5,2)"/>-<xsl:value-of select="substring($date,1,4)"/>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template name="IMGLINK">
		<xsl:element name="A">
			<xsl:attribute name="href"><xsl:value-of select="STYFILENAME"/></xsl:attribute>
			<xsl:attribute name="style">cursor:hand</xsl:attribute>
			<xsl:element name="img">
				<xsl:attribute name="src">IHE_PDI/<xsl:value-of select="SERIES/IMAGE/PATH"/></xsl:attribute>
				<xsl:attribute name="height">100</xsl:attribute>				
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template name="SERIMGLINK">
		<xsl:element name="A">
			<xsl:attribute name="href"><xsl:value-of select="../STYFILENAME"/>#SERID-<xsl:value-of select="SERID"/></xsl:attribute>
			<xsl:attribute name="style">cursor:hand</xsl:attribute>
			<xsl:element name="img">
				<xsl:attribute name="src">IHE_PDI/<xsl:value-of select="IMAGE/PATH"/></xsl:attribute>
				<xsl:attribute name="height">80</xsl:attribute>				
			</xsl:element>
		</xsl:element>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template match="PATIENT">
		<table border="0" cellspacing="0" width="100%" >
			<tr>
				<td>
					<table border="0" cellpadding="4" width="100%" id="TABLEPAZIENTE">
						<tr>
							<td colspan="9"/>
						</tr>
						<tr>
							<!--<td width="50%" nowrap="1"><h3/></td>-->
							<td class="PATIENTLABELTEXT" nowrap="1">Nome Paziente:</td>
							<td class="PATIENTFIELDTEXT" nowrap="1">
								<xsl:value-of select="PATNAME"/>
							</td>
							<td class="PATIENTLABELTEXT" nowrap="1">Identificativo:</td>
							<td class="PATIENTFIELDTEXT" nowrap="1">
								<xsl:value-of select="PATID"/>
							</td>
							<td class="PATIENTLABELTEXT" nowrap="1">Data di Nascita:</td>
							<td class="PATIENTFIELDTEXT" nowrap="1">
								<xsl:call-template name="PATBIRTHDATE"/>
							</td>
							<td class="PATIENTLABELTEXT" nowrap="1">Sesso:</td>
							<td class="PATIENTFIELDTEXT" nowrap="1" width="100%">
								<xsl:value-of select="PATSEX"/>
							</td>
							<td width="100%"/>
						</tr>
					</table>
				</td>
			</tr>
			<xsl:for-each select="./STUDY">
				<tr>
					<td>
						<xsl:apply-templates select="."/>
					</td>
				</tr>
			</xsl:for-each>
		</table>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template match="STUDY">
		<div class="StudyBody">
			<table border="0" cellspacing="0" cellpadding="4" width="100%">
				<tr>
					<td>
						<div class="STYDESCRIPTION">Esame: <xsl:value-of select="STYDESCRIPTION"/> del <xsl:call-template name="STYDATE"/>
						</div>
					</td>
				</tr>
				<xsl:for-each select="./REPORT">
					<tr>
						<td style="padding-left: 30px;">
							<div>
								<xsl:choose>
									<xsl:when test="(position() mod 2) = 0">
										<xsl:attribute name="class">RowEven</xsl:attribute>
									</xsl:when>
									<xsl:otherwise>
										<xsl:attribute name="class">RowOdd</xsl:attribute>
									</xsl:otherwise>
								</xsl:choose>
								<xsl:apply-templates select="."/>
							</div>
						</td>
					</tr>
				</xsl:for-each>
				<xsl:for-each select="./SERIES">
					<xsl:variable name="SRMODAL" select="SERMODALITY"/>
					<xsl:choose>
						<xsl:when test="$SRMODAL='SR' and count(STRUCTURED_REPORT) > 0">
							<tr>
								<td style="padding-left: 30px;">
									<div>
										<xsl:choose>
											<xsl:when test="(position() mod 2) = 0">
												<xsl:attribute name="class">RowEven</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">RowOdd</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:call-template name="STRUCT_REPORT"/>
									</div>
								</td>
							</tr>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:for-each select="./SERIES">
					<xsl:variable name="DOCMODAL" select="SERMODALITY"/>
					<xsl:choose>
						<xsl:when test="$DOCMODAL='DOC' or $DOCMODAL='PDF'">
							<tr>
								<td style="padding-left: 30px;">
									<div>
										<xsl:choose>
											<xsl:when test="(position() mod 2) = 0">
												<xsl:attribute name="class">RowEven</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">RowOdd</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:call-template name="DOC_REPORT"/>
									</div>
								</td>
							</tr>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
				<xsl:for-each select="./SERIES">
					<xsl:variable name="MODALITY" select="SERMODALITY"/>
					<xsl:choose>
						<xsl:when test="$MODALITY='PR'"/>
						<xsl:when test="$MODALITY='KO'"/>
						<xsl:when test="$MODALITY='SR' and count(STRUCTURED_REPORT) > 0"/>
						<xsl:when test="$MODALITY='DOC'"/>
						<xsl:when test="$MODALITY='PDF'"/>
						<xsl:otherwise>
							<tr>
								<td colspan="4">
									<div>
										<xsl:choose>
											<xsl:when test="(position() mod 2) = 0">
												<xsl:attribute name="class">RowEven</xsl:attribute>
											</xsl:when>
											<xsl:otherwise>
												<xsl:attribute name="class">RowOdd</xsl:attribute>
											</xsl:otherwise>
										</xsl:choose>
										<xsl:apply-templates select="."/>
									</div>
								</td>
							</tr>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</table>
		</div>
		<br/>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template name="STRUCT_REPORT">
		<xsl:for-each select="./STRUCTURED_REPORT">
			<xsl:variable name="report" select="SRPATH"/>
			<xsl:element name="A">
				<xsl:attribute name="href"><xsl:value-of select="$report"/></xsl:attribute>
		Visualizza referto strutturato: <xsl:value-of select="substring($report,25,9)"/><br></br>
				<xsl:attribute name="style">cursor:hand</xsl:attribute>
			<!-- -->
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template name="DOC_REPORT">
		<xsl:for-each select="./DOCUMENT">
			<xsl:variable name="doc" select="DOCPATH"/>
			<xsl:element name="A">
				<xsl:attribute name="href"><xsl:value-of select="$doc"/></xsl:attribute>
		Visualizza documento: <xsl:value-of select="substring($doc,25,9)"/><br></br>
			<xsl:attribute name="style">cursor:hand</xsl:attribute>
			</xsl:element>
		</xsl:for-each>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template match="REPORT">
		<table>
			<tr>
				<td class="STUDYLABELTEXT">Visualizza il referto dell'esame: 
					<xsl:element name="a">
						<xsl:attribute name="class">STUDYFIELDTEXT</xsl:attribute>
						<xsl:attribute name="href"><xsl:value-of select="@FILENAME"/></xsl:attribute>
						<xsl:attribute name="align">right</xsl:attribute>
						<!-- tolgo la parte ./reports dal nome del collegamento -->
						<xsl:variable name="pdf" select="@FILENAME"/>
						<xsl:value-of select="substring($pdf,11,64)"/>
						<!--<xsl:value-of select="@FILENAME"/>-->
					</xsl:element>
				</td>
			</tr>
		</table>
	</xsl:template>
	<!-- ************************************************************************************************ -->
	<xsl:template match="SERIES">
		<table border="0" cellspacing="0" cellpadding="2">
			<tr>
				<td rowspan="4" colspan="2">
					<xsl:call-template name="SERIMGLINK"/>
				</td>
			</tr>
			<tr align="left">
				<td class="STUDYLABELTEXT">Identificativo:</td>
				<td width="100%" class="STUDYFIELDTEXT">
					<xsl:value-of select="SERID"/>
				</td>
			</tr>
			<tr align="left">
				<td class="STUDYLABELTEXT" nowrap="1">Descrizione Serie:</td>
				<td nowrap="1" class="STUDYFIELDTEXT">
					<xsl:value-of select="SERDESCRIPTION"/>
				</td>
			</tr>
			<tr align="left">
				<td class="STUDYLABELTEXT">Modalit:</td>
				<td class="STUDYFIELDTEXT">
					<xsl:value-of select="SERMODALITY"/>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
